% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmc_caption.R
\name{pmc_caption}
\alias{pmc_caption}
\title{Split captions into sentences}
\usage{
pmc_caption(doc)
}
\arguments{
\item{doc}{\code{xml_document} from PubMed Central}
}
\value{
a tibble with tag, label, sentence number and text
}
\description{
Split figure, table and supplementary material captions into sentences
}
\examples{
# doc <- pmc_xml("PMC2231364") # OR
doc <- xml2::read_xml(system.file("extdata/PMC2231364.xml",
  package = "tidypmc"
))
x <- pmc_caption(doc)
x
dplyr::filter(x, sentence == 1)
}
\author{
Chris Stubben
}
