% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_het_obs.R
\name{pop_het_obs}
\alias{pop_het_obs}
\title{Compute the population observed heterozygosity}
\usage{
pop_het_obs(
  .x,
  by_locus = FALSE,
  include_global = FALSE,
  n_cores = bigstatsr::nb_cores()
)
}
\arguments{
\item{.x}{a \code{\link{gen_tibble}} (usually grouped, as obtained by using
\code{\link[dplyr:group_by]{dplyr::group_by()}}, otherwise the full tibble will be considered as
belonging to a single population).}

\item{by_locus}{boolean, determining whether Ho should be returned by
locus(TRUE), or as a single genome wide value (FALSE, the default).}

\item{include_global}{boolean determining whether, besides the population
specific estimates, a global estimate should be appended. Note that this
will return a vector of n populations plus 1 (the global value), or a
matrix with n+1 columns if \code{by_locus=TRUE}.}

\item{n_cores}{number of cores to be used, it defaults to
\code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}}
}
\value{
a vector of mean population observed heterozygosities (if
\code{by_locus=FALSE}), or a matrix of estimates by locus (rows are loci,
columns are populations, \code{by_locus=TRUE})
}
\description{
This function computes population heterozygosity, using the formula of Nei
(1987).
}
\details{
Within population observed heterozygosity \eqn{\hat{h}_o} for a
locus with \eqn{m} alleles is defined as:\cr \eqn{\hat{h}_o=
  1-\sum_{k=1}^{s} \sum_{i=1}^{m}  \hat{X}_{kii}/s}\cr where\cr
\eqn{\hat{X}_{kii}} represents the proportion of homozygote \eqn{i} in the
sample for the \eqn{k}th population and\cr \eqn{s} the number of
populations,\cr following equation 7.38 in Nei(1987) on pp.164. In our
specific case, there are only two alleles, so \eqn{m=2}. For population
specific estimates, the sum is done over a single value of \eqn{k}.
\eqn{\hat{h}_o} at the genome level is simply the mean of the locus
estimates.
}
\examples{
\dontshow{if (all(rlang::is_installed(c("RhpcBLASctl", "data.table")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
example_gt <- load_example_gt("grouped_gen_tbl")

# Compute expected heterozygosity
example_gt \%>\% pop_het_obs()

# To include the global expected heterozygosity, set include_global = TRUE
example_gt \%>\% pop_het_obs(include_global = TRUE)

# To return by locus, set by_locus = TRUE
example_gt \%>\% pop_het_obs(by_locus = TRUE)
\dontshow{\}) # examplesIf}
}
\references{
Nei M. (1987) Molecular Evolutionary Genetics. Columbia
University Press
}
