% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_t_test.R
\name{report_t_test}
\alias{report_t_test}
\title{Report method for a t-test}
\usage{
report_t_test(results, identifier, statistic = NULL)
}
\arguments{
\item{results}{A tidy stats list.}

\item{identifier}{A character string identifying the model.}

\item{statistic}{A character string of a statistic you want to extract from a model.}
}
\description{
Function to report a t-test in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Example: t-test
report(results, identifier = "t_test")
report(results, identifier = "t_test", statistic = "p")

}
