% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.R
\name{dt}
\alias{dt}
\title{Pipeable data.table call}
\usage{
dt(.df, ...)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Arguments passed to data.table call. See \code{?data.table::`[.data.table` }}
}
\description{
Pipeable data.table call.

This function does not use data.table's modify-by-reference.

Has experimental support for tidy evaluation for custom functions.
}
\examples{
df <- tidytable(
  x = 1:3,
  y = 4:6,
  z = c("a", "a", "b")
)

df \%>\%
  dt(, double_x := x * 2) \%>\%
  dt(order(-double_x))

# Experimental support for tidy evaluation for custom functions
add_one <- function(data, col) {
  data \%>\%
    dt(, new_col := {{ col }} + 1)
}

df \%>\%
  add_one(x)
}
