% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate.R
\name{dt_relocate}
\alias{dt_relocate}
\title{Relocate a column to a new position}
\usage{
dt_relocate(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{A selection of columns}

\item{.before}{Column to move selection before}

\item{.after}{Column to move selection after}
}
\description{
Move a column or columns to a new position

Supports enhanced selection
}
\examples{
test_df <- data.table::data.table(
  a = 1:5,
  b = 1:5,
  c = c("a","a","a","b","b"),
  d = c("a","a","a","b","b"))

test_df \%>\%
  dt_relocate(c, .before = b)

test_df \%>\%
  dt_relocate(is.numeric, .after = c)
}
