% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmdpstitle.R
\name{rmdpstitle}
\alias{rmdpstitle}
\title{Get Titles and Footnotes for all TLGs or one specific TLG}
\usage{
rmdpstitle(
  df,
  tblid,
  idvar = "tblid",
  identifier = "identifier",
  text = "text"
)
}
\arguments{
\item{df}{dataframe with three variables; table name, row identifier (TITLE
or FOOTNOTEn), and title/footnote text to display}

\item{tblid}{character vector containing the table id, optional, used to
subset df to a specific table (defaults to tblid)}

\item{idvar}{character vector containing the variable in df that contains
your table id}

\item{identifier}{character vector containing the variable name in df that
contains your record identifier (defaults to "identifier")}

\item{text}{character vector containing the variable name in df that
contains your title and footnote text (defaults to "text")}
}
\value{
list of length two, the first element contains the titles as a tibble
and the second contains the footnotes as a list
}
\description{
Get Titles and Footnotes for all TLGs or one specific TLG
}
\examples{
tblid <- "TSIDEM01"

titles <-tibble::tribble(
  ~tblid, ~identifier,                  ~text,
  "TSIDEM01",     "TITLE", "Demographics Example",
  "TSIDEM01", "FOOTNOTE1",    "Example footnote."
)

title_foot <- rmdpstitle(titles, tblid)

title_foot[[1]]
title_foot[[2]]
}
