% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{get_route_frequency}
\alias{get_route_frequency}
\title{Get Route Frequency}
\usage{
get_route_frequency(gtfs_obj, start_hour = 6, end_hour = 22,
  service_ids = c(), dow = c(1, 1, 1, 1, 1, 0, 0))
}
\arguments{
\item{gtfs_obj}{a list of gtfs dataframes as read by the trread package.}

\item{start_hour}{(optional) an integer, default 6 (6 am)}

\item{end_hour}{(optional) an integer, default 22 (10 pm)}

\item{service_ids}{(optional) a string from the calendar dataframe identifying a particular service schedule.}

\item{dow}{(optional) an integer vector with days of week. monday=1. default: c(1,1,1,1,1,0,0)}
}
\value{
a dataframe of routes with variables (gtfs_obj$.$routes_frequency) for headway/frequency for a route within a given time frame
}
\description{
Note that some GTFS feeds contain a frequency data frame already.
Consider using this instead, as it will be more accurate than what
tidytransit calculates.
}
\examples{
data(gtfs_duke)
routes_frequency <- get_route_frequency(gtfs_duke)
x <- order(routes_frequency$median_headways)
head(routes_frequency[x,])
}
