% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{set_dates_services}
\alias{set_dates_services}
\title{Returns all possible date/service_id combinations as a data frame}
\usage{
set_dates_services(gtfs_obj)
}
\arguments{
\item{gtfs_obj}{gtfs feed (tidygtfs object)}
}
\value{
a date_service data frame
}
\description{
Use it to summarise service. For example, get a count of the number of
services for a date. See example.
}
\examples{
library(dplyr)
local_gtfs_path <- system.file("extdata", "google_transit_nyc_subway.zip", package = "tidytransit")
nyc <- read_gtfs(local_gtfs_path)
nyc_services_by_date <- nyc$.$dates_services
# count the number of services running on each date
nyc_services_by_date \%>\% group_by(date) \%>\% count()
}
\keyword{internal}
