% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_pluck_water.R
\name{convert_water}
\alias{convert_water}
\title{Convert `water` class object to a dataframe}
\usage{
convert_water(water)
}
\arguments{
\item{water}{A water class object}
}
\value{
A data frame containing columns for all non-NA water slots.
}
\description{
This converts a `water` class to a dataframe with individual columns for each slot (water quality parameter) in the `water`.
This is useful for one-off checks and is applied in all `fn_once` tidywater functions. For typical applications,
there may be a `fn_once` tidywater function that provides a more efficient solution.
}
\examples{

library(dplyr)
library(tidyr)

# Generates 1 row dataframe
example_df <- define_water(ph = 7, temp = 20, alk = 100) \%>\%
  convert_water()

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  mutate(to_dataframe = map(defined_water, convert_water)) \%>\%
  unnest(to_dataframe) \%>\%
  select(-defined_water)

}
\seealso{
\code{\link{define_water}}
}
