% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveresid_o3.R
\name{solveresid_o3}
\alias{solveresid_o3}
\title{Determine ozone decay}
\source{
U.S. EPA (2001)

See reference list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
solveresid_o3(water, dose, time)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}.}

\item{dose}{Applied ozone dose in mg/L}

\item{time}{Ozone contact time in minutes}
}
\value{
A numeric value for the resiudal ozone.
}
\description{
This function applies the ozone decay model to a water created by \code{\link{define_water}}
from U.S. EPA (2001) equation 5-128.
}
\examples{
ozone_resid <- define_water(7, 20, 100, doc = 2, toc = 2.2, uv254 = .02, br = 50) \%>\%
  solveresid_o3(dose = 2, time = 10)

}
