% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_property.R
\name{tw_get_p1}
\alias{tw_get_p1}
\title{Get Wikidata property of an item as a character vector of the same length as
input}
\usage{
tw_get_p1(
  id,
  p,
  latest_start_time = FALSE,
  language = tidywikidatar::tw_get_language(),
  id_df = NULL,
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 0
)
}
\arguments{
\item{id}{A character vector, must start with Q, e.g. "Q180099" for the
anthropologist Margaret Mead. Can also be a data frame of one row,
typically generated with \code{\link[=tw_search]{tw_search()}} or a combination of \code{\link[=tw_search]{tw_search()}}
and \code{\link[=tw_filter_first]{tw_filter_first()}}.}

\item{p}{A character vector, a property. Must always start with the capital
letter "P", e.g. "P31" for "instance of".}

\item{latest_start_time}{Logical, defaults to \code{FALSE}. If \code{TRUE}, returns the
property that has the most recent start time ("P580") as qualifier if
\code{only_first} is set to \code{TRUE}, or returns a list ordered by start time if
\code{only_first} is set to \code{FALSE}. If no such qualifier is found, then it is
ignored.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{id_df}{Default to \code{NULL}. If given, it should be a dataframe typically
generated with \code{\link[=tw_get]{tw_get()}}, and is used instead of calling Wikidata or
using SQLite cache. Ignored when \code{id} is of length more than one.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}
}
\value{
A character vector of the same length as the input.
}
\description{
This function wraps \code{\link[=tw_get_p]{tw_get_p()}}, but always sets \code{only_first} and
\code{preferred} to \code{TRUE} in order to give back always a character vector.
}
\examples{
tw_get_p1(id = "Q180099", "P26")
}
