% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legislative.R
\name{voting_districts}
\alias{voting_districts}
\title{Download a voting districts shapefile into R}
\usage{
voting_districts(state = NULL, county = NULL, cb = FALSE, year = 2020, ...)
}
\arguments{
\item{state}{The state for which you'd like to retrieve data.  Can be a state name,
state abbreviation, or FIPS code. When \code{NULL} and combined with
\code{cb = TRUE}, a national dataset of voting districts will be returned.}

\item{county}{The county for which you are requesting data.  Can be a county name or
FIPS code.  If \code{NULL} (the default), data for the entire state will
be returned.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{year}{The data year.  Defaults to 2020; the function will error for different years.
A prior version of this function accessed an older voting districts dataset for
2012; that year is no longer supported.}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
Obtain feature geometry for 2020 voting districts, which align with voting districts for the
2020 PL-94171 redistricting data from the US Census Bureau.
}
\details{
The US Census Bureau describes \emph{voting districts} as follows:
Voting district (VTD) is a generic term adopted by the Bureau of the Census
to include the wide variety of small polling areas, such as election districts,
precincts, or wards, that State and local governments create for the purpose
of administering elections. Some States also use groupings of these entities
to define their State and local legislative districts, as well as the districts they
define for election of members to the U.S. House of Representatives. In a
nationwide cooperative program for the 1980 census, the Census Bureau
gave States the opportunity to request use of these election precinct boundaries as the boundaries of #' census enumeration districts (EDs) or, in some areas, census blocks.

Support for voting districts in tigris 1.5 and higher is aligned with the 2020 PL redistricting
data.  The argument \code{cb = FALSE} retrieves voting districts from the TIGER/Line PL
shapefiles.  A generalized version from the cartographic boundary dataset is available with the
argument \code{cb = TRUE}.
}
\examples{
\dontrun{#'
library(tigris)

ia <- voting_districts("Iowa")

plot(ia$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch14GARM.pdf}

Other legislative district functions: 
\code{\link{congressional_districts}()},
\code{\link{state_legislative_districts}()}
}
\concept{legislative district functions}
