#' Support for native LaTeX output of R graphics
#'
#' The tikzDevice package implements the [tikz()] ouput device which
#' generates R graphics in a LaTeX friendly format. LaTeX handles the
#' typesetting of all text in graphics generated by `tikz`. This allows for
#' seamless integration between these graphics and documents that are also being
#' typeset by LaTeX. Using LaTeX to generate graph text also means that
#' \strong{LaTeX mathematics can be typeset directly into labels and
#' annotations}.
#'
#' @name tikzDevice-package
#' @aliases tikzDevice-package tikzDevice
#' @docType package
#' @section Options That Affect Package Behavior: The \pkg{tikzDevice} package
#'   is currently influenced by a number of global options that may be set in
#'   scripts, from the console or in a `.Rprofile` file. All of the options
#'   can be set by using `options(<option> = <value>)`.  These options
#'   allow for the use of custom `documentclass` declarations, LaTeX
#'   packages, and typesetting engines (e.g. XeLaTeX or LuaLaTeX). The defaults,
#'   if are any for a given option, are shown below the description. The global
#'   options are:
#'
#'   \describe{
#'
#'   \item{`tikzDefaultEngine`}{ Specifies which typesetting engine
#'   functions in the tikzDevice package will prefer. Current possible values
#'   are `pdftex`, `xetex` or `luatex`. Respectively, these
#'   values trigger the use of the `pdflatex`, `xelatex` and
#'   `lualatex` compilers.  }
#'
#'   \item{`tikzLatex`}{ Specifies the location of the LaTeX compiler to be
#'   used by \pkg{tikzDevice}. Setting this option may help the package locate a
#'   missing compiler. The default is searched for when the package is loaded,
#'   otherwise it can be set manually. This option may be set as follows:
#'   `options( tikzLatex = '/path/to/latex/compiler' )`.  }
#'
#'   \item{`tikzXelatex`}{ Functions similar to `tikzLatex`, except
#'   this option specifies the location of the XeLaTeX compiler.  }
#'
#'   \item{`tikzLualatex`}{ Functions similar to `tikzLatex`, except
#'   this option specifies the location of the LuaLaTeX compiler.  }
#'
#'   \item{`tikzMetricsDictionary`}{ When using the graphics device
#'   provided by \pkg{tikzDevice}, you may notice that appears to "lag" or
#'   "hang" when commands such as `plot()` are executed. This is because
#'   the device must query the LaTeX compiler for string widths and font
#'   metrics. For a normal plot, this may happen dozens or hundreds of times-
#'   hence becomes unresponsive for a while. The good news is that the
#'   [tikz()] code is designed to cache the results of these
#'   computations so they need only be performed once for each string or
#'   character. By default, these values are stored in a temporary cache file
#'   which is deleted when is shut down.  A location for a permanent cache file
#'   may be specified by setting the value of `tikzMetricsDictionary` in
#'   `.Rprofile` with `options(tikzMetricsDictionary =
#'   '/path/to/dictionary/location')`.  }
#'
#'   \item{`tikzDocumentDeclaration`}{ A string. The LaTeX `documentclass`
#'   declaration used in output files when `standAlone == TRUE`.
#'   `tikzDocumentDeclaration` also influences the calculation of font
#'   metrics. The default value is: \code{options(tikzDocumentDeclaration =
#'   "\\documentclass[10pt]{article}")} }
#'
#'   \item{`tikzLatexPackages`}{ A character vector. These are the packages
#'   which are included when using the `pdftex` engine and
#'   [tikz()] is used with the the `standAlone` option as well as
#'   when font metrics are calculated.  }
#'
#'   \item{`tikzXelatexPackages`}{ This option works like
#'   `tikzLatexPackages`, except is is used when the `xetex` engine is
#'   in use.  }
#'
#'   \item{`tikzLualatexPackages`}{ This option works like
#'   `tikzXelatexPackages`, except is is used when the `luatex` engine
#'   is in use.  }
#'
#'   \item{`tikzFooter`}{ A character vector. The footer to be used only
#'   when `standAlone==TRUE`.  }
#'
#'   \item{`tikzMetricPackages`}{ A character vector. These are the
#'   packages which are additionally loaded when doing font metric calculations.
#'   As you see below, the font encoding is set to Type 1. This is very
#'   important so that character codes of LaTeX and match up. The default value
#'   is: \code{options(tikzMetricPackages = c( "\\usepackage[utf8]{inputenc}",
#'   "\\usepackage[T1]{fontenc}", "\\usetikzlibrary{calc}" ))} }
#'
#'   \item{`tikzUnicodeMetricPackages`}{ This vector is used when font
#'   metric calculations are performed using the `xetex` or `luatex`
#'   engines. It should have the same contents as `tikzMetricPackages` with
#'   the addition of the `fontspec` and `xunicode` packages.  }
#'
#'   \item{`tikzSanitizeCharacters`}{ A character vector of special latex
#'   characters to replace. These values should correspond to the replacement
#'   values from the `tikzReplacementCharacters` option. See
#'   [sanitizeTexString()] for more details.  }
#'
#'   \item{`tikzReplacementCharacters`}{ A character vector of replacements
#'   for special latex characters. These values should correspond to the values
#'   from the `tikzSanitizeCharacters` option.  }
#'
#'   \item{`tikzLwdUnit`}{ A numeric that denotes the number of `pt`s in LaTeX that `lwd=1` in R is
#'   translated to. Defaults to 0.4 (LaTeX and TikZ default); for compatibility
#'   with R default, please use 72.27/96 (96 pixels in R is 1 inch, which is 72.27
#'   points in TeX).}
#'
#'   \item{`tikzPdftexWarnUTF`}{ A `TRUE/FALSE` value that controls
#'   whether warnings are printed if Unicode characters are sent to a device
#'   using the `pdftex` engine.  }
#'
#'   \item{`tikzSymbolicColors`}{ A logical value indicating whether colors
#'   are written as RGB values or as symbolic names in which case the need to be
#'   defined in the LaTeX document. }
#'
#'   \item{`tikzMaxSymbolicColors`}{ an integer number indicating the
#'   maximal number of distinct colors to write symbolically. Any excess color
#'   will be defined as if `symbolicColors` was set to `FALSE`.} }
#'
#'   Default values for all options may be viewed or restored using the
#'   [setTikzDefaults()] function.
#' @author See `packageDescription("tikzDevice")`.
#'
#'   Submit bug reports to: <https://github.com/yihui/tikzDevice/issues>
#' @seealso [tikz()]
#' @references The TikZ and PGF Packages: Manual for version 2.00\cr
#'   <http://sourceforge.net/projects/pgf>\cr Till Tanatu, February 20, 2008
#' @keywords package
NULL

#' @importFrom grDevices as.raster dev.cur dev.list dev.off png
#' @importFrom graphics grconvertX grconvertY par plot.new rasterImage
#' @importFrom stats complete.cases
#' @importFrom utils packageVersion
#' @useDynLib tikzDevice, .registration = TRUE
NULL
