\name{hmm.setup}
\alias{hmm.setup}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Create HMM from Initial Parameter Estimates Obtained from Data}
\description{
   Convenient way to obtain initial parameter estimates from data. 
}
\usage{
hmm.setup(data, state = c("enriched", "non-enriched"), 
    probe.region = 35, frag.size = 1000, pos.state = 1, 
    em.type = "tDist", max.prob = 1, df = 9)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{Observation sequence. This can be either a single sequence or a \code{list} of sequences.}
  \item{state}{Vector of state names for HMM.}
  \item{probe.region}{Length of genomic region represented by one probe (on average).}
  \item{frag.size}{Expected size of ChIP fragments.}
  \item{pos.state}{Index of  state which is considered to represent \sQuote{positive} result.}
  \item{em.type}{Character string identifying type of emission distribution to be used. Currently only "\code{tDist}" 
  is supported.}
  \item{max.prob}{Maximum probability allowed in transition matrix. Setting this to less than 1 ensures that 
  there are no null transitions.}
  \item{df}{Degrees of freedom for emission distributions.}
}
\details{
  The parameter estimates are obtained by first clustering the observations, then the
  mean and variance of the resulting groups are used together with cluster size, expected
  fragment size and probe density to generate initial values for model parameters.
  
  The parameter values generated by this procedure are only a rough guess and have to be
  optimised before the model is used for data analysis.
}
\value{
   Object of class \code{contHMM}.
}

\note{This method currently only supports two state HMMs with t distributions.}

\author{Peter Humburg}

\seealso{\code{\linkS4class{contHMM}}, \code{\link{getHMM}}, \code{\linkS4class{tDist}}, \code{\link{viterbiEM}}}
\examples{
## create two state HMM with t distributions
state.names <- c("one","two")
transition <- c(0.035, 0.01)
location <- c(-1, 2)
scale <- c(1, 1)
df <- c(4, 6)
hmm <- getHMM(list(a=transition, mu=location, sigma=scale, nu=df), 
    state.names)

## obtain observation sequence from model
obs <- sampleSeq(hmm, 500)

## build model from data
model <- hmm.setup(obs, state = c("one", "two"),df=5)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{utilities}
