% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NDRectangle.R
\name{tiledb_ndrectangle_datatype}
\alias{tiledb_ndrectangle_datatype}
\title{Get the datatype of a named \code{tiledb_ndrectangle} dimension}
\usage{
tiledb_ndrectangle_datatype(ndr, dimname)
}
\arguments{
\item{ndr}{A TileDB NDRectangle object}

\item{dimname}{A character variable with the dimension for which to get a datatype}
}
\value{
The \code{tiledb_ndrectangle} dimension datatype as a character
}
\description{
Get the datatype of a named \code{tiledb_ndrectangle} dimension
}
\examples{
\dontshow{ctx <- tiledb_ctx(limitTileDBCores())}
if (tiledb_version(TRUE) >= "2.26.0") {
   dom <- tiledb_domain(dim = tiledb_dim("d1", c(1L, 100L), type = "INT32"))
   ndr <- tiledb_ndrectangle(dom)
   tiledb_ndrectangle_datatype(ndr, "d1")
}
}
