% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar}
\alias{calendar}
\title{Create a table of common time units from a date or datetime sequence.}
\usage{
calendar(
  x,
  label = TRUE,
  week_start = getOption("lubridate.week.start", 1),
  fiscal_start = getOption("lubridate.fiscal.start", 1),
  name = "time"
)
}
\arguments{
\item{x}{date or datetime vector.}

\item{label}{Logical. Should labelled (ordered factor) versions of
week day and month be returned? Default is \code{TRUE}.}

\item{week_start}{day on which week starts following ISO conventions - 1
means Monday, 7 means Sunday (default). When \code{label = TRUE},
this will be the first level of the returned factor.
You can set \code{lubridate.week.start} option to control this parameter globally.}

\item{fiscal_start}{Numeric indicating the starting month of a fiscal year.}

\item{name}{Name of date/datetime column.}
}
\value{
An object of class \code{tibble}.
}
\description{
Create a table of common time units from a date or datetime sequence.
}
\examples{
library(timeplyr)
library(lubridate)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
# Create a calendar for the current year
from <- floor_date(today(), unit = "year")
to <- ceiling_date(today(), unit = "year", change_on_boundary = TRUE) - days(1)

my_seq <- time_seq(from, to, time_by = "day")
calendar(my_seq)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
