% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics-tk_stl_diagnostics.R
\name{tk_stl_diagnostics}
\alias{tk_stl_diagnostics}
\title{Group-wise STL Decomposition (Season, Trend, Remainder)}
\usage{
tk_stl_diagnostics(
  .data,
  .date_var,
  .value,
  .frequency = "auto",
  .trend = "auto",
  .message = TRUE
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{.frequency}{Controls the seasonal adjustment (removal of seasonality).
Input can be either "auto", a time-based definition (e.g. "2 weeks"),
or a numeric number of observations per frequency (e.g. 10).
Refer to \code{\link[=tk_get_frequency]{tk_get_frequency()}}.}

\item{.trend}{Controls the trend component.
For STL, trend controls the sensitivity of the lowess smoother, which is used to remove the remainder.}

\item{.message}{A boolean. If \code{TRUE}, will output information related to automatic frequency
and trend selection (if applicable).}
}
\value{
A \code{tibble} or \code{data.frame} with Observed, Season, Trend, Remainder,
and Seasonally-Adjusted features
}
\description{
\code{tk_stl_diagnostics()} is the preprocessor for \code{plot_stl_diagnostics()}.
It helps by automating frequency and trend selection.
}
\details{
The \code{tk_stl_diagnostics()} function generates a Seasonal-Trend-Loess decomposition.
The function is "tidy" in the sense that it works
on data frames and is designed to work with \code{dplyr} groups.

\strong{STL method}:

The STL method implements time series decomposition using
the underlying \code{\link[stats:stl]{stats::stl()}}. The decomposition separates the
"season" and "trend" components from
the "observed" values leaving the "remainder".

\strong{Frequency & Trend Selection}

The user can control two parameters: \code{.frequency} and \code{.trend}.
\enumerate{
\item The \code{.frequency} parameter adjusts the "season" component that is removed
from the "observed" values.
\item The \code{.trend} parameter adjusts the
trend window (\code{t.window} parameter from \code{stl()}) that is used.
}

The user may supply both \code{.frequency}
and \code{.trend} as time-based durations (e.g. "6 weeks") or numeric values
(e.g. 180) or "auto", which automatically selects the frequency and/or trend
based on the scale of the time series.
}
\examples{
library(dplyr)
library(timetk)


# ---- GROUPS & TRANSFORMATION ----
m4_daily \%>\%
    group_by(id) \%>\%
    tk_stl_diagnostics(date, box_cox_vec(value))

# ---- CUSTOM TREND ----
m4_weekly \%>\%
    group_by(id) \%>\%
    tk_stl_diagnostics(date, box_cox_vec(value), .trend = "2 quarters")

}
