% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-lag.R
\name{lag_vec}
\alias{lag_vec}
\alias{lead_vec}
\title{Lag Transformation}
\usage{
lag_vec(x, lag = 1)

lead_vec(x, lag = -1)
}
\arguments{
\item{x}{A vector to be lagged.}

\item{lag}{Which lag (how far back) to be included in the differencing calculation.
Negative lags are leads.}
}
\value{
A numeric vector
}
\description{
\code{lag_vec()} applies a Lag Transformation.
}
\details{
\strong{Benefits:}

This function is \code{NA} padded by default so it works well with \code{dplyr::mutate()} operations.
The function allows both lags and leads (negative lags).

\strong{Lag Calculation}

A lag is an offset of \code{lag} periods. \code{NA} values are returned for the number of \code{lag} periods.

\strong{Lead Calculation}

A \emph{negative lag} is considered a lead. The only difference between \code{lead_vec()} and \code{lag_vec()} is
that the \code{lead_vec()} function contains a starting negative value.
}
\examples{
library(dplyr)

# --- VECTOR ----

# Lag
1:10 \%>\% lag_vec(lag = 1)

# Lead
1:10 \%>\% lag_vec(lag = -1)


# --- MUTATE ----

m4_daily \%>\%
    group_by(id) \%>\%
    mutate(lag_1 = lag_vec(value, lag = 1))


}
\seealso{
Modeling and Advanced Lagging:
\itemize{
\item \code{\link[recipes:step_lag]{recipes::step_lag()}} - Recipe for adding lags in \code{tidymodels} modeling
\item \code{\link[=tk_augment_lags]{tk_augment_lags()}} - Add many lags group-wise to a data.frame (tibble)
}

Vectorized Transformations:
\itemize{
\item Box Cox Transformation: \code{\link[=box_cox_vec]{box_cox_vec()}}
\item Lag Transformation: \code{\link[=lag_vec]{lag_vec()}}
\item Differencing Transformation: \code{\link[=diff_vec]{diff_vec()}}
\item Rolling Window Transformation: \code{\link[=slidify_vec]{slidify_vec()}}
\item Loess Smoothing Transformation: \code{\link[=smooth_vec]{smooth_vec()}}
\item Fourier Series: \code{\link[=fourier_vec]{fourier_vec()}}
\item Missing Value Imputation for Time Series: \code{\link[=ts_impute_vec]{ts_impute_vec()}}, \code{\link[=ts_clean_vec]{ts_clean_vec()}}
}
}
