% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{draw_heatmap}
\alias{draw_heatmap}
\title{draw a heatmap plot}
\usage{
draw_heatmap(
  n,
  group_list,
  scale_before = FALSE,
  n_cutoff = 3,
  legend = FALSE,
  show_rownames = FALSE,
  annotation_legend = FALSE,
  split_column = FALSE,
  show_column_title = FALSE,
  color = (grDevices::colorRampPalette(c("#2fa1dd", "white", "#f87669")))(100),
  color_an = c("#2fa1dd", "#f87669", "#e6b707", "#868686", "#92C5DE", "#F4A582",
    "#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F", "#E5C494",
    "#B3B3B3"),
  scale = TRUE,
  main = NA,
  ...
)
}
\arguments{
\item{n}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{scale_before}{deprecated parameter}

\item{n_cutoff}{3 by defalut , scale before plot and set a cutoff,usually 2 or 1.6}

\item{legend}{logical,show legend or not}

\item{show_rownames}{logical,show rownames or not}

\item{annotation_legend}{logical,show annotation legend or not}

\item{split_column}{split column by group_list}

\item{show_column_title}{show column title or not}

\item{color}{color for heatmap}

\item{color_an}{color for column annotation}

\item{scale}{logical,scale the matrix or not}

\item{main}{the title of the plot}

\item{...}{other parameters from pheatmap}
}
\value{
a heatmap plot according to \code{exp} and grouped by \code{group}.
}
\description{
print a heatmap plot for expression matrix and group by group_list praramter, exp will be scaled.
}
\examples{
#example data
exp = matrix(abs(rnorm(60,sd = 16)),nrow = 10)
exp[,4:6] <- exp[,4:6]+20
colnames(exp) <- paste0("sample",1:6)
rownames(exp) <- paste0("gene",1:10)
exp[1:4,1:4]
group_list = factor(rep(c("A","B"),each = 3))
draw_heatmap(exp,group_list)
#use iris
n = t(iris[,1:4]);colnames(n) = 1:150
group_list = iris$Species
draw_heatmap(n,group_list)
draw_heatmap(n,group_list,color = colorRampPalette(c("green","black","red"))(100),
             color_an = c("red","blue","pink") )
}
\seealso{
\code{\link{draw_pca}};\code{\link{draw_volcano}};\code{\link{draw_venn}}
}
\author{
Xiaojie Sun
}
