% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_points.R
\name{type_points}
\alias{type_points}
\title{Points plot type}
\usage{
type_points()
}
\description{
Type function for plotting points, i.e. a scatter plot.
}
\examples{
# "p" type convenience character string
tinyplot(Sepal.Length ~ Petal.Length, data = iris, type = "p")

# Same result with type_points()
tinyplot(Sepal.Length ~ Petal.Length, data = iris, type = type_points())

# Note: Specifying the type here is redundant. Like base plot, tinyplot
# automatically produces a scatter plot if x and y are numeric
tinyplot(Sepal.Length ~ Petal.Length, data = iris)

# Grouped scatter plot example
tinyplot(Sepal.Length ~ Petal.Length | Species, data = iris)

# Continuous grouping (with gradient legend)
tinyplot(Sepal.Length ~ Petal.Length | Sepal.Width, data = iris, pch = 19)

}
