% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scholar_table.R
\name{scholar_table}
\alias{scholar_table}
\title{Show Scholar Profile Table}
\usage{
scholar_table(
  profile,
  as_raw_html = FALSE,
  title_citations = "Citations",
  title_publications = "Publications",
  caption_citations = gt::md(paste("**Update**:", Sys.Date())),
  caption_publications = caption_citations
)
}
\arguments{
\item{profile}{Result from \link{tinyscholar}.}

\item{as_raw_html}{If \code{TRUE} (not default), convert result \link[gt:gt]{gt::gt} object to raw html text.
This is useful when apply the result to GitHub Markdown file.}

\item{title_citations}{Title for table \code{citations}. Set by \link[gt:tab_header]{gt::tab_header}.}

\item{title_publications}{Title for table \code{publications}. Set by \link[gt:tab_header]{gt::tab_header}.}

\item{caption_citations}{Caption for table \code{citations}. Set by \link[gt:tab_source_note]{gt::tab_source_note}.}

\item{caption_publications}{Caption for table \code{publications}. Set by \link[gt:tab_source_note]{gt::tab_source_note}.}
}
\value{
a length-2 list of \link[gt:gt]{gt::gt}/\code{html} object.
}
\description{
Show Scholar Profile Table
}
\seealso{
\link{tinyscholar}, \link{scholar_plot}
}
