% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vector.R
\name{plot_vector}
\alias{plot_vector}
\title{Create Plot Vector}
\usage{
plot_vector(
  output = "html",
  fun = NULL,
  data = NULL,
  color = "black",
  xlim = NULL,
  height = 1,
  height_plot = 400,
  width_plot = 1200,
  images = NULL,
  sprintf = "\%s",
  assets = "tinytable_assets",
  ...
)
}
\arguments{
\item{output}{Output format. One of "html", "latex", "typst", "markdown", etc.}

\item{fun}{String or function to generate inline plots.
\itemize{
\item Built-in plot types (strings):
\itemize{
\item \code{"histogram"}: Creates histograms from numeric vectors. Accepts \code{color} argument.
\item \code{"density"}: Creates density plots from numeric vectors. Accepts \code{color} argument.
\item \code{"bar"}: Creates horizontal bar charts from single numeric values. Accepts \code{color} and \code{xlim} arguments.
\item \code{"barpct"}: Creates horizontal percentage bar charts from single numeric values between 0 and 1. Accepts \code{color} and \code{background} arguments.
\item \code{"line"}: Creates line plots from data frames with \code{x} and \code{y} columns. Accepts \code{color} and \code{xlim} arguments.
}
\item Custom functions:
\itemize{
\item Functions that return \code{ggplot2} objects.
\item Functions that return another function which generates a base \code{R} plot, ex: \code{function(x) {function() hist(x)}}
\item Note: When using custom ggplot2 functions that return plots with text elements, the text size will normally need to be adjusted because the plot is inserted as a very small image in the table. Text sizes of 1 or smaller often work well (e.g., \code{theme(text = element_text(size = 1))}).
}
\item See the tutorial on the \code{tinytable} website for more information.
}}

\item{data}{a list of data frames or vectors to be used by the plotting functions in \code{fun}.}

\item{color}{string Name of color to use for inline plots (passed to the \code{col} argument base \code{graphics} plots in \code{R}).}

\item{xlim}{Numeric vector of length 2.}

\item{height}{Numeric, the height of the images in the table in em units.}

\item{height_plot}{Numeric, the height of generated plot images in pixels (default: 400).}

\item{width_plot}{Numeric, the width of generated plot images in pixels (default: 1200).}

\item{images}{Character vector, the paths to the images to be inserted. Paths are relative to the main table file or Quarto (Rmarkdown) document.}

\item{sprintf}{Character string, a sprintf format string to format the generated cell content. Default is "\%s" which displays the content as-is. Use this to wrap images or plots in custom markup.}

\item{assets}{Path to the directory where generated assets are stored. This path is relative to the location where a table is saved.}

\item{...}{Extra arguments are passed to the function in \code{fun}. Important: Custom plotting functions must always have \code{...} as an argument.}
}
\value{
A character vector with plot file paths or HTML tags.
}
\description{
Create Plot Vector
}
\details{
This function creates plots by creating a temporary \code{tt()} object and applying \code{plot_tt()}. It returns a character vector containing the image paths or HTML tags for the plots.
}
\examples{
\dontrun{
# Create histogram plots
plot_data <- list(rnorm(100), rnorm(50))
plot_vector(fun = "histogram", data = plot_data, output = "html")

# Create density plots
plot_vector(fun = "density", data = plot_data, output = "latex")

# Create bar plots from single values
bar_data <- list(0.5, 0.8, 0.3)
plot_vector(fun = "barpct", data = bar_data, output = "html")
}
}
