% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlars_model.R
\name{tlars_model}
\alias{tlars_model}
\title{Creates a Terminating-LARS (T-LARS) object}
\usage{
tlars_model(
  lars_state,
  X,
  y,
  num_dummies,
  verbose = FALSE,
  intercept = FALSE,
  standardize = TRUE,
  type = "lar",
  info = TRUE
)
}
\arguments{
\item{lars_state}{List of variables associated with previous T-LARS step (necessary to restart
the forward selection process exactly where it was previously terminated). The lars_state
is extracted from an object of class tlars_cpp via get_all() and is only required when the
object (or its pointer) of class tlars_cpp is deleted or got lost in another R session (e.g.,
in parallel processing).}

\item{X}{Real valued predictor matrix.}

\item{y}{Response vector.}

\item{num_dummies}{Number of dummies that are appended to the predictor matrix.}

\item{verbose}{Logical. If TRUE progress in computations is shown when performing T-LARS steps on the created model.}

\item{intercept}{Logical. If TRUE an intercept is included.}

\item{standardize}{Logical. If TRUE the predictors are standardized and the response is centered.}

\item{type}{'lar' for 'LARS' and 'lasso' for Lasso.}

\item{info}{Logical. If TRUE and object is not recreated from previous T-LARS state, then information about the created object is printed.}
}
\value{
Object of the class tlars_cpp.
}
\description{
Creates an object of the class tlars_cpp.
}
\examples{
data("Gauss_data")
X <- Gauss_data$X
y <- drop(Gauss_data$y)
p <- ncol(X)
n <- nrow(X)
num_dummies <- p
dummies <- matrix(stats::rnorm(n * p), nrow = n, ncol = num_dummies)
XD <- cbind(X, dummies)
mod_tlars <- tlars_model(X = XD, y = y, num_dummies = num_dummies)
mod_tlars
}
