% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layers_raster.R
\name{tm_raster}
\alias{tm_raster}
\alias{opt_tm_raster}
\title{Map layer: raster}
\usage{
tm_raster(
  col = tm_vars(),
  col.scale = tm_scale(),
  col.legend = tm_legend(),
  col.chart = tm_chart_none(),
  col.free = NA,
  col_alpha = tm_const(),
  col_alpha.scale = tm_scale(),
  col_alpha.legend = tm_legend(),
  col_alpha.chart = tm_chart_none(),
  col_alpha.free = NA,
  zindex = NA,
  group = NA,
  group.control = "check",
  options = opt_tm_raster(),
  ...
)

opt_tm_raster(interpolate = FALSE)
}
\arguments{
\item{col, col.scale, col.legend, col.chart, col.free}{Visual variable that determines the color. See details.}

\item{col_alpha, col_alpha.scale, col_alpha.legend, col_alpha.chart, col_alpha.free}{Visual variable that determines the color transparency. See details.}

\item{zindex}{Map layers are drawn on top of each other. The \code{zindex} numbers
(one for each map layer) determines the stacking order.
By default the map layers are drawn in the order they are called.}

\item{group}{Name of the group to which this layer belongs. This is only
relevant in view mode, where layer groups can be switched (see \code{group.control})}

\item{group.control}{In view mode, the group control determines how layer groups
can be switched on and off. Options: \code{"radio"} for radio buttons
(meaning only one group can be shown), \code{"check"} for check boxes
(so multiple groups can be shown), and \code{"none"} for no control
(the group cannot be (de)selected).}

\item{options}{options passed on to the corresponding \verb{opt_<layer_function>} function}

\item{...}{to catch deprecated arguments from version < 4.0}

\item{interpolate}{Should the raster image be interpolated? Currently only applicable in view mode (passed on to \code{\link[grid:grid.raster]{grid}})}
}
\description{
Map layer that draws rasters. Supported visual variable is: \code{col} (the  color).
}
\details{
The visual variable arguments (e.g. \code{col}) can be specified with either a data
variable name (e.g., a spatial vector attribute or a raster layer of the object
specified in \code{\link[=tm_shape]{tm_shape()}}), or with a visual value (for \code{col}, a color is expected).
See \href{https://r-tmap.github.io/tmap/articles/basics_vv}{vignette about visual variables}.

Multiple values can be specified: in that case facets are created.
These facets can be combined with other faceting data variables, specified with \code{\link[=tm_facets]{tm_facets()}}.
See \href{https://r-tmap.github.io/tmap/articles/basics_facets}{vignette about facets}.
\itemize{
\item The \verb{*.scale} arguments determine the used scale to map the data values to
visual variable values. These can be specified with one of the available
\verb{tm_scale_*()} functions. The default is specified by the tmap option (\code{\link[=tm_options]{tm_options()}}) \code{scales.var}.
See \href{https://r-tmap.github.io/tmap/articles/basics_scales}{vignette about scales}.
\item The \verb{*.legend} arguments determine the used legend, specified with \code{\link[=tm_legend]{tm_legend()}}.
The default legend and its settings are determined by the tmap options (\code{\link[=tm_options]{tm_options()}}) \code{legend.} .
See \href{https://r-tmap.github.io/tmap/articles/basics_legends}{vignette about legends}.
\item The \verb{*.chart} arguments specify additional charts, specified with \code{tm_chart_}, e.g. \code{\link[=tm_chart_histogram]{tm_chart_histogram()}}.
See \href{https://r-tmap.github.io/tmap/articles/basics_charts}{vignette about charts}.
\item The \verb{*.free} arguments determine whether scales are applied freely across facets, or shared.
A logical value is required. They can also be specified with a vector of three
logical values; these determine whether scales are applied freely per facet dimension.
This is only useful when facets are applied (see \code{\link[=tm_facets]{tm_facets()}}).
There are maximally three facet dimensions: rows, columns, and pages. This only
applies for a facet grid (\code{\link[=tm_facets_grid]{tm_facets_grid()}}). For instance, \code{col.free = c(TRUE, FALSE, FALSE)}
means that for the visual variable \code{col}, each row of facets will have its own
scale, and therefore its own legend. For facet wraps and stacks
(\code{\link[=tm_facets_wrap]{tm_facets_wrap()}} and \code{\link[=tm_facets_stack]{tm_facets_stack()}}) there is only one facet dimension,
so the \verb{*.free} argument requires only one logical value.
}
}
\examples{
\dontrun{
# load land data
data(land, World)

tm_shape(land) +
	tm_raster("cover")

tm_shape(land) +
	tm_raster("elevation", col.scale = tm_scale_continuous(values = terrain.colors(9))) +
	tm_shape(World) +
	tm_borders()
}
}
