% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/limma.R
\name{tmodLimmaTest}
\alias{tmodLimmaTest}
\title{Run tmod enrichment tests directly on a limma object}
\usage{
tmodLimmaTest(f, genes, order.by = "msd", tmodFunc = tmodCERNOtest,
  coef = NULL, ...)
}
\arguments{
\item{f}{result of linear model fit produced by limma functions lmFit and eBayes}

\item{genes}{Either the name of the column in f$genes which
contains the gene symbols corresponding to the gene set collection used, or
a character vector with gene symbols}

\item{order.by}{How the gene names should be ordered: "msd" (default), "pval" or "lfc"}

\item{tmodFunc}{The function to run the enrichment tests. Either tmodCERNOtest or tmodUtest}

\item{coef}{If not NULL, only run tmod on these coefficients}

\item{...}{Further parameters passed to the tmod test function}
}
\value{
A list with length equal to the number of coeffients. Each
element is the value returned by tmod test function. The list can be
directly passed to the functions tmodSummary and tmodPanelPlot.
}
\description{
This function will order the genes according to each of the coefficient
found in a limma object and run an enrichment test on the ordered list.
}
\details{
For each coefficient in the fit returned by the eBayes / lmFit functions
from the limma package, tmodLimmaTest will order the genes run an enrichment test and return
the results.

The ordering of the genes according to a certain metric is the fundament for
gene enrichment analysis. tmodLimmaTest allows three orderings: p-values, "MSD" and log fold changes.
The default MSD ("minimal significant difference") is the lower boundary of the 95%
confidence interval for positive log fold changes, and 0 minus the upper boundary
of the 95% confidence interval for negative log fold changes. MSD performs
better than ordering by p-value or by log fold change. See discussion in
the package vignette.
}
\examples{
library(limma)
data(Egambia)
design <- cbind(Intercept=rep(1, 30), TB=rep(c(0,1), each= 15))
fit <- eBayes( lmFit(Egambia[,-c(1:3)], design))
ret <- tmodLimmaTest(fit, genes=Egambia$GENE_SYMBOL)
tmodSummary(ret)
tmodPanelPlot(ret)
}
\seealso{
tmodCERNOtest, tmodUtest, tmodPlotPanel, tmodSummary
}

