% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rtnorm}
\alias{rtnorm}
\title{Random Generation for Truncated Univariate Normal}
\usage{
rtnorm(mean, sd, lower, upper)
}
\arguments{
\item{mean}{Vector of means, whose length is the number of observations.}

\item{sd}{Standard deviation. Defaults to 1.}

\item{lower}{A scalar of lower bound for truncation, or a vector of 
lower bounds with the same length as \code{mean}.}

\item{upper}{A scalar of upper bound for truncation, or a vector of 
upper bounds with the same length as \code{mean}.}
}
\value{
Returns a vector of random numbers following the specified 
  truncated univariate normal distribution.
}
\description{
Draws from truncated univariate normal distribution within an interval.
}
\examples{
set.seed(1203)
x = rtnorm(mean=rep(1,1000), sd=2, lower=-2, upper=3)
summary(x)

}
