% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_compare}
\alias{plot_compare}
\alias{plot_compare.tna}
\title{Plot the difference network between two models}
\usage{
plot_compare(x, ...)

\method{plot_compare}{tna}(x, y, theme = NULL, palette = "colorblind", ...)
}
\arguments{
\item{x}{A \code{tna} object. It will be the principal model.}

\item{...}{Additional arguments passed to \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{y}{A \code{tna} object. It will be the model subtracted from the
principal model.}

\item{theme}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{palette}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
}
\value{
A \code{qgraph} object displaying the difference network between the
two models.
}
\description{
Plots the difference network between model \code{x} and model \code{y}. The edges are
computed from subtracting the two models. The pie chart is the difference in
initial probabilities between model \code{x} and model \code{y}. Green color indicates
that \code{x}is greater than \code{y}and red indicates otherwise.
}
\examples{
model_x <- tna(group_regulation[group_regulation[, 1] == "plan", ])
model_y <- tna(group_regulation[group_regulation[, 1] != "plan", ])
plot_compare(model_x, model_y)

}
\seealso{
Core functions
\code{\link{build_model}()},
\code{\link{centralities}()},
\code{\link{plot.tna}()},
\code{\link{plot.tna_centralities}()}
}
\concept{core}
