% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_.R
\name{sp_read}
\alias{sp_read}
\alias{sp_write}
\title{Read/Write from Sharepoint}
\usage{
sp_read(path, site = NULL, drive = NULL, type = NULL, ...)

sp_write(x, path, site = NULL, drive = NULL, type = NULL, ...)
}
\arguments{
\item{path}{The location in the Sharepoint drive}

\item{site}{Site identifier. Can be the site name, id, URL, or an ms_site object. If no site identifier is provided, uses the stored default site if it exists.}

\item{drive}{Drive identifier. Can be the drive name, id, or an ms_drive object. If site is provided but drive is not, uses the first drive of the provided site. If neither is provided, uses the stored default drive if it exists.}

\item{type}{Optional. One of "dataframe" (for delimited files), "xlsx", or "rds". Uses the file extension to determine type if not provided.}

\item{...}{Additional arguments passed on to the reading/writing function.}

\item{x}{The object to be written}
}
\value{
\code{sp_read()} returns an R object as specified by type. \code{sp_write()}
returns x, invisibly
}
\description{
Read or write data to/from a Sharepoint drive. Can be used with default
site/drive set by \code{\link[=sp_defaults]{sp_defaults()}} or with a specified site/drive.

Currently supported file types include: \code{.csv}, \code{.csv2}, \code{.tsv}, \code{.xls},
\code{.xlsx}, \code{.rds}

These functions will attempt to use the appropriate read/write function based
on the file extension, however this can be overridden by specifying type.

The \code{...} parameter is passed on to the appropriate reading or writing
function. See the details section for more information on these functions
by type.

If the folder in \code{path} does not yet exist, the user will be prompted if they
would like to create it.
}
\section{Details}{
For more information on methods (shown as \verb{$__()} below) see documentation
on \link[Microsoft365R:ms_drive]{Microsoft365R::ms_drive}.
\subsection{Reading Functions}{
\itemize{
\item ".csv", ".csv2", ".tsv" are read using the \verb{$load_dataframe()} method,
which uses \code{\link[readr:read_delim]{readr::read_delim()}}.
\item ".rds" is read using the \verb{$load_rds()} method which accepts no additional
arguments.
\item ".xls" and ".xlsx" are read using \code{\link[readxl:read_excel]{readxl::read_excel()}} (if installed).
The function will download the excel file temporarily, then import it and
delete the temporary copy
}
}

\subsection{Writing Functions}{
\itemize{
\item ".csv", ".csv2", ".tsv" are written using the \verb{$save_dataframe()} method
and uses \code{\link[readr:write_delim]{readr::write_delim()}}. Delimiter will be assumed by the extension
unless provided in a \code{delim} argument
\item ".rds" is written using the \verb{$save_rds()} method, which accepts no
additional arguments
\item ".xlsx" is written using \code{\link[writexl:write_xlsx]{writexl::write_xlsx()}} (if
installed) and then uploaded using the \verb{$upload_file()} method.
}
}
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Set site defaults
sp_defaults(site = "Data Analytics")

# Write a file
sp_write(mtcars, "mtcars.csv")

# Write a file, specifying type and adding additional parameters
sp_write(mtcars, "mtcars.txt", type = "dataframe", delim = "|")

# Read a file
x <- sp_read("mtcars.csv")
y <- sp_read("mtcars.txt", type = "dataframe", delim = "|")

# Save / load an .rdata file using ms_drive methods
dr <- sp_drive() # Get stored default ms_drive object
dr$save_rdata(x, y, file = "data.rdata")
dr$load_rdata("data.rdata")

\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sp_upload]{sp_upload()}}, \code{\link[=sp_download]{sp_download()}}; \verb{$upload_file()}, \verb{$download_file()}, \verb{$save_rdata()}, \verb{$load_rdata()} from \link[Microsoft365R:ms_drive]{Microsoft365R::ms_drive}
}
