% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getNullCounts}
\alias{getNullCounts}
\title{Counts nulls per column in the table.}
\usage{
getNullCounts(channel, tableName, tableInfo = NULL, include = NULL,
  except = NULL, schema = NULL, output = "long", where = NULL,
  test = FALSE)
}
\arguments{
\item{channel}{object as returned by \code{\link{odbcConnect}}.}

\item{tableName}{name of the table in Aster.}

\item{tableInfo}{pre-built summary of columns to use (require when \code{test=TRUE}). 
See \code{\link{sqlColumns}} or \code{\link{getTableSummary}}.}

\item{include}{a vector of column names to include. Output never contains attributes other than in the list.}

\item{except}{a vector of column names to exclude. Output never contains attributes from the list.}

\item{schema}{NULL or character: optional schema to restric table search to signle schema. In general,
table search performed across whole database. Including \code{schema} restricts it to this single 
schema only.}

\item{output}{Default output is a data frame in \code{'long'} format. Other options include 
\code{'wide'} format and \code{'matrix'}.}

\item{where}{specifies criteria to satisfy by the table rows before applying computation. 
The creteria are expressed in the form of SQL predicates (inside \code{WHERE} clause).}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \link{RODBC} 
functions like \link{sqlQuery} and \link{sqlSave}).}
}
\description{
Counts nulls per column in the table.
}
\examples{
if (interactive()) {
# initialize connection to Dallas database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")

null_counts = getNullCounts(conn, "baseball.batting", 
                            include=c('g','ab','r','h','so','bb','cs'), 
                            where='yearid > 2000')

}
}

