% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-selection.R
\name{grid_selection_cell}
\alias{grid_selection_cell}
\title{Cell selection (in shiny)}
\usage{
grid_selection_cell(grid, inputId, selectionUnit = c("cell", "row"))
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{selectionUnit}{The unit of selection on grid.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Cell selection (in shiny)
}
\examples{
if (interactive()) {
  library(shiny)
  library(toastui)

  ui <- fluidPage(
    tags$h2("datagrid cell selection"),
    datagridOutput("grid_1"),
    verbatimTextOutput("result_1"),
    datagridOutput("grid_2"),
    verbatimTextOutput("result_2")
  )

  server <- function(input, output, session) {

    df <- data.frame(
      index = 1:12,
      month = month.name,
      letters = letters[1:12]
    )

    output$grid_1 <- renderDatagrid({
      datagrid(df) \%>\%
        grid_selection_cell(
          inputId = "cells"
        )
    })
    output$result_1 <- renderPrint({
      input$cells
    })

    output$grid_2 <- renderDatagrid({
      datagrid(df) \%>\%
        grid_selection_cell(
          inputId = "rows",
          selectionUnit = "row"
        )
    })
    output$result_2 <- renderPrint({
      input$rows
    })
  }

  shinyApp(ui, server)
}
}
