% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{prepare_heatmap_data}
\alias{prepare_heatmap_data}
\title{Generate Distance Matrix Heatmap Data}
\usage{
prepare_heatmap_data(
  distance_matrix,
  cluster_rows = FALSE,
  cluster_cols = FALSE
)
}
\arguments{
\item{distance_matrix}{Square symmetric matrix of distances}

\item{cluster_rows}{Logical; whether to cluster rows}

\item{cluster_cols}{Logical; whether to cluster columns}
}
\value{
A list of data prepared for generating a heatmap of the distance matrix:
\item{matrix_data}{The distance \code{matrix}, potentially reordered by clustering.}
\item{row_order}{An integer vector of the row indices after clustering. If \code{cluster_rows}
is \code{FALSE}, this is the original order.}
\item{col_order}{An integer vector of the column indices after clustering. If \code{cluster_cols}
is \code{FALSE}, this is the original order.}
\item{stats}{A list of summary statistics for the distance matrix, including \code{mean}, \code{sd},
\code{min}, \code{max}, and \code{completeness}.}
}
\description{
Prepares distance matrix data for heatmap visualization by handling missing values
and calculating relevant statistics.
}
\examples{
# Create a sample distance matrix
dist_mat <- matrix(runif(25), 5, 5)

# Prepare data for a heatmap
heatmap_data <- prepare_heatmap_data(dist_mat)
print(heatmap_data$stats$completeness)

}
