% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectplot.R
\name{get_overlapping_snps_by_pos}
\alias{get_overlapping_snps_by_pos}
\title{Get variants that overlap between two datasets}
\usage{
get_overlapping_snps_by_pos(df1, df2, verbose = FALSE)
}
\arguments{
\item{df1}{A dataframe of variants, has to contain CHROM and POS}

\item{df2}{A dataframe of variants, has to contain CHROM and POS}

\item{verbose}{A logical scalar (default: FALSE). Assign to TRUE to get information on which alleles are matched and which are not.}
}
\value{
The input dataframe containing only those variants with matched alleles in the snpset
}
\description{
\code{get_overlapping_snps_by_pos()}
}
\examples{
\donttest{
CD_UKBB_index_snps <- get_best_snp_per_MB(CD_UKBB)
get_overlapping_snps_by_pos(CD_UKBB_index_snps, CD_FINNGEN)
}

}
