% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectplot.R
\name{match_alleles}
\alias{match_alleles}
\title{Match the variants in the snpset by their alleles}
\usage{
match_alleles(df, verbose = FALSE)
}
\arguments{
\item{df}{A dataframe that is in the snpset format (like returned by the get_snpset() function)}

\item{verbose}{A logical scalar (default: FALSE). Assign to TRUE to get information on which alleles are matched and which are not.}
}
\value{
The input dataframe containing only those variants with matched alleles in the snpset
}
\description{
\code{match_alleles()}
}
\examples{
\donttest{
CD_UKBB_index_snps <-get_best_snp_per_MB(CD_UKBB)
snpset <- create_snpset(CD_UKBB_index_snps,CD_FINNGEN)
match_alleles(snpset)
}

}
