% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_cross}
\alias{torch_cross}
\title{Cross}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{other}{(Tensor) the second input tensor}

\item{dim}{(int, optional) the dimension to take the cross-product in.}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Cross
}
\section{cross(input, other, dim=-1, out=None) -> Tensor }{


Returns the cross product of vectors in dimension \code{dim} of \code{input}
and \code{other}.

\code{input} and \code{other} must have the same size, and the size of their
\code{dim} dimension should be 3.

If \code{dim} is not given, it defaults to the first dimension found with the
size 3.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(4, 3))
a
b = torch_randn(c(4, 3))
b
torch_cross(a, b, dim=2)
torch_cross(a, b)
}
}
