% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R, R/wrapers.R
\name{torch_fft_ifft}
\alias{torch_fft_ifft}
\title{Ifft}
\usage{
torch_fft_ifft(self, n = NULL, dim = -1L, norm = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor}

\item{n}{(int, optional) – Signal length. If given, the input will either be
zero-padded or trimmed to this length before computing the IFFT.}

\item{dim}{(int, optional) – The dimension along which to take the one
dimensional IFFT.}

\item{norm}{(str, optional) – Normalization mode. For the backward transform,
these correspond to:
\itemize{
\item "forward" - no normalization
\item "backward" - normalize by 1/n
\item "ortho" - normalize by 1/sqrt(n) (making the IFFT orthonormal)
Calling the forward transform with the same normalization mode will apply an
overall normalization of 1/n between the two transforms. This is required to
make ifft() the exact inverse.
Default is "backward" (normalize by 1/n).
}}
}
\description{
Computes the one dimensional inverse discrete Fourier transform of input.
}
\examples{
if (torch_is_installed()) {
t <- torch_arange(start = 0, end = 3)
t
x <- torch_fft_fft(t, norm = "backward")
torch_fft_ifft(x)


}
}
