% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_outer}
\alias{torch_outer}
\title{Outer}
\usage{
torch_outer(self, vec2)
}
\arguments{
\item{self}{(Tensor) 1-D input vector}

\item{vec2}{(Tensor) 1-D input vector}
}
\description{
Outer
}
\note{
This function does not broadcast.
}
\section{outer(input, vec2, *, out=None) -> Tensor }{


Outer product of \code{input} and \code{vec2}.
If \code{input} is a vector of size \eqn{n} and \code{vec2} is a vector of
size \eqn{m}, then \code{out} must be a matrix of size \eqn{(n \times m)}.
}

\examples{
if (torch_is_installed()) {

v1 <- torch_arange(1., 5.)
v2 <- torch_arange(1., 4.)
torch_outer(v1, v2)
}
}
