% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nn_module}
\alias{nn_module}
\title{Base class for all neural network modules.}
\usage{
nn_module(
  classname = NULL,
  inherit = nn_Module,
  ...,
  private = NULL,
  active = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{classname}{an optional name for the module}

\item{inherit}{an optional module to inherit from}

\item{...}{methods implementation}

\item{private}{passed to \code{\link[R6:R6Class]{R6::R6Class()}}.}

\item{active}{passed to \code{\link[R6:R6Class]{R6::R6Class()}}.}

\item{parent_env}{passed to \code{\link[R6:R6Class]{R6::R6Class()}}.}
}
\description{
Your models should also subclass this class.
}
\details{
Modules can also contain other Modules, allowing to nest them in a tree
structure. You can assign the submodules as regular attributes.
}
\examples{
if (torch_is_installed()) {
model <- nn_module(
 initialize = function() {
   self$conv1 <- nn_conv2d(1, 20, 5)
   self$conv2 <- nn_conv2d(20, 20, 5)
 },
 forward = function(input) {
   input <- self$conv1(input)
   input <- nnf_relu(input)
   input <- self$conv2(input)
   input <- nnf_relu(input)
   input
 }
)

}
}
