% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_softshrink}
\alias{nn_softshrink}
\title{Softshrink module}
\usage{
nn_softshrink(lambd = 0.5)
}
\arguments{
\item{lambd}{the \eqn{\lambda} (must be no less than zero) value for the Softshrink formulation. Default: 0.5}
}
\description{
Applies the soft shrinkage function elementwise:
}
\details{
\deqn{
  \mbox{SoftShrinkage}(x) =
  \left\{ \begin{array}{ll}
x - \lambda, & \mbox{ if } x > \lambda \\
x + \lambda, & \mbox{ if } x < -\lambda \\
0, & \mbox{ otherwise }
\end{array}
\right.
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_softshrink()
input <- torch_randn(2)
output <- m(input)

}
}
