% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_spectrogram}
\alias{functional_spectrogram}
\title{Spectrogram (functional)}
\usage{
functional_spectrogram(
  waveform,
  pad,
  window,
  n_fft,
  hop_length,
  win_length,
  power,
  normalized
)
}
\arguments{
\item{waveform}{(tensor): Tensor of audio of dimension (..., time)}

\item{pad}{(integer): Two sided padding of signal}

\item{window}{(tensor or function): Window tensor that is applied/multiplied to each
frame/window or a function that generates the window tensor.}

\item{n_fft}{(integer): Size of FFT}

\item{hop_length}{(integer): Length of hop between STFT windows}

\item{win_length}{(integer): Window size}

\item{power}{(numeric): Exponent for the magnitude spectrogram, (must be > 0) e.g.,
1 for energy, 2 for power, etc. If NULL, then the complex spectrum is returned instead.}

\item{normalized}{(logical): Whether to normalize by magnitude after stft}
}
\value{
\code{tensor}: Dimension (..., freq, time), freq is n_fft \%/\% 2 + 1 and n_fft is the
number of Fourier bins, and time is the number of window hops (n_frame).
}
\description{
Create a spectrogram or a batch of spectrograms from a raw audio signal.
The spectrogram can be either magnitude-only or complex.
}
