% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-wavernn.R
\name{model_melresnet}
\alias{model_melresnet}
\title{MelResNet}
\usage{
model_melresnet(
  n_res_block = 10,
  n_freq = 128,
  n_hidden = 128,
  n_output = 128,
  kernel_size = 5
)
}
\arguments{
\item{n_res_block}{the number of ResBlock in stack.  (Default: \code{10})}

\item{n_freq}{the number of bins in a spectrogram.  (Default: \code{128})}

\item{n_hidden}{the number of hidden dimensions of resblock.  (Default: \code{128})}

\item{n_output}{the number of output dimensions of melresnet.  (Default: \code{128})}

\item{kernel_size}{the number of kernel size in the first Conv1d layer.  (Default: \code{5})}
}
\value{
Tensor shape:  (n_batch, n_output, n_time - kernel_size + 1)
}
\description{
MelResNet layer uses a stack of ResBlocks on spectrogram.
Pass the input through the MelResNet layer.
}
\details{
forward param:
specgram  (Tensor): the input sequence to the MelResNet layer (n_batch, n_freq, n_time).
}
\examples{

if(torch::torch_is_installed()) {
 melresnet = model_melresnet()
 input = torch::torch_rand(10, 128, 512)  # a random spectrogram
 output = melresnet(input)  # shape: (10, 128, 508)
}

}
