% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tranforms.R
\name{transform_mfcc}
\alias{transform_mfcc}
\title{Mel-frequency Cepstrum Coefficients}
\usage{
transform_mfcc(
  sample_rate = 16000,
  n_mfcc = 40,
  dct_type = 2,
  norm = "ortho",
  log_mels = FALSE,
  ...
)
}
\arguments{
\item{sample_rate}{(int, optional): Sample rate of audio signal. (Default: \code{16000})}

\item{n_mfcc}{(int, optional): Number of mfc coefficients to retain. (Default: \code{40})}

\item{dct_type}{(int, optional): type of DCT (discrete cosine transform) to use. (Default: \code{2})}

\item{norm}{(str, optional): norm to use. (Default: \code{'ortho'})}

\item{log_mels}{(bool, optional): whether to use log-mel spectrograms instead of db-scaled. (Default: \code{FALSE})}

\item{...}{(optional): arguments for \link{transform_mel_spectrogram}.}
}
\value{
\code{tensor}: specgram_mel_db of size (..., \code{n_mfcc}, time).
}
\description{
Create the Mel-frequency cepstrum coefficients from an audio signal.
}
\details{
forward param:
waveform (tensor): Tensor of audio of dimension (..., time)

By default, this calculates the MFCC on the DB-scaled Mel spectrogram.
This output depends on the maximum value in the input spectrogram, and so
may return different values for an audio clip split into snippets vs. a
a full clip.
}
