% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-wavernn.R
\name{model_resblock}
\alias{model_resblock}
\title{ResBlock}
\usage{
model_resblock(n_freq = 128)
}
\arguments{
\item{n_freq}{the number of bins in a spectrogram.  (Default: \code{128})}
}
\value{
Tensor shape:  (n_batch, n_freq, n_time)
}
\description{
ResNet block based on "Deep Residual Learning for Image Recognition".
Pass the input through the ResBlock layer. The paper link is \url{https://arxiv.org/pdf/1512.03385.pdf}.
}
\details{
forward param:
specgram  (Tensor): the input sequence to the ResBlock layer (n_batch, n_freq, n_time).
}
\examples{
if(torch::torch_is_installed()) {
resblock = model_resblock()
input = torch::torch_rand(10, 128, 512)  # a random spectrogram
output = resblock(input)  # shape: (10, 128, 512)
}
}
