% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/live.R
\name{stub}
\alias{stub}
\title{Stub Function Arguments}
\usage{
stub(func, ..., envir = parent.frame())
}
\arguments{
\item{func}{function for which the arguments should be stubbed}

\item{...}{non-default arguments of \code{func}}

\item{envir}{environment to which symbols should be assigned}
}
\value{
list of symbols that are assigned to \code{envir}
}
\description{
\code{stub()} assigns all arguments of a given function as symbols
to the specified environment (usually the current environment)
}
\details{
Stub is thought to be used for interactive testing and unit testing.
It does not work for primitive functions.
}
\examples{
f <- function(x, y = 2, z = 3) x + y + z
args <- stub(f, x = 1) # assigns x = 1, y = 2 and z = 3 to current env
}
\keyword{live}
