% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.r
\name{interpolate}
\alias{interpolate}
\title{Interpolate geodesically between bases.}
\usage{
interpolate(basis_set, angle = 0.05, cycle = FALSE)
}
\arguments{
\item{basis_set}{input basis set}

\item{angle}{target distance (in radians) between bases}

\item{cycle}{For \code{\link{planned_tour}} cycle through continuously (TRUE) or stop after first pass (FALSE)}
}
\description{
This function takes a set of bases and produces a tour by geodesically
interpolating between each basis
}
\examples{
t1 <- save_history(flea[, 1:6], grand_tour(1), max = 10)
dim(t1)
dim(interpolate(t1, 0.01))
dim(interpolate(t1, 0.05))
dim(interpolate(t1, 0.1))
}
\keyword{hplot}
