% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_summary_stats.R
\name{calc_summary_stats}
\alias{calc_summary_stats}
\title{Calculates the Effective Sample Sizes of one estimated variable's trace.}
\usage{
calc_summary_stats(traces, sample_interval)
}
\arguments{
\item{traces}{one or more traces, supplies as either, (1) a numeric
vector or, (2) a data frame of numeric values.}

\item{sample_interval}{the interval (the number of state
transitions between samples) of the MCMC run that produced the trace.
Using a different \code{sample_interval} than the actually used
sampling interval will result in bogus return values.}
}
\value{
the summary statistics of the traces. If one numeric
  vector is supplied, a list is returned with the elements
  listed below. If the traces are supplied as a data frame,
  a data frame is returned with the elements listed
  below as column names.\cr
  The elements are:\cr
  \itemize{
    \item{\code{mean}: mean}
    \item{\code{stderr_mean}: standard error of the mean}
    \item{\code{stdev}: standard deviation}
    \item{\code{variance}: variance}
    \item{\code{mode}: mode}
    \item{\code{geom_mean}: geometric mean}
    \item{\code{hpd_interval_low}: lower bound of 95\% highest posterior density}
    \item{\code{hpd_interval_high}: upper bound of 95\% highest posterior density}
    \item{\code{act}: auto correlation time}
    \item{\code{ess}: effective sample size}
  }
}
\description{
Calculates the Effective Sample Sizes of one estimated variable's trace.
}
\note{
This function assumes the burn-in is removed.
  Use \code{\link{remove_burn_in}} (on a vector) or
  \code{\link{remove_burn_ins}} (on a data frame) to remove
  the burn-in.
}
\examples{
  estimates_all <- parse_beast_log(get_tracerer_path("beast2_example_output.log"))
  estimates <- remove_burn_ins(estimates_all, burn_in_fraction = 0.1)

  # From a single variable's trace
  sum_stats_posterior <- calc_summary_stats(
    estimates$posterior,
    sample_interval = 1000
  )

  testit::assert("mean" \%in\% names(sum_stats_posterior))

  # From all variables' traces
  sum_stats <- calc_summary_stats(
    estimates,
    sample_interval = 1000
  )

  testit::assert("mean" \%in\% colnames(sum_stats))
}
\seealso{
Use \code{\link{calc_summary_stats_trace}} to calculate the
  summary statistics of one trace (stored as a numeric vector). Use
  \code{\link{calc_summary_stats_traces}} to calculate the
  summary statistics of more traces (stored as a data frame).
}
\author{
Richel J.C. Bilderbeek
}
