% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move2KBA.r
\name{move2KBA}
\alias{move2KBA}
\title{Import Movebank data sets for track2KBA analysis}
\usage{
move2KBA(movebankID = NULL, user = NULL, password = NULL, filename = NULL)
}
\arguments{
\item{movebankID}{character or numeric. Character: full name of the study, as
stored on Movebank. Numeric: Movebank ID of the study. Both can be obtained
 on the Study Details page on Movebank (\url{https://www.movebank.org}) or with
 \code{\link[move]{getMovebankID}}.}

\item{user}{Username associated with your Movebank account.}

\item{password}{password associated with your Movebank username.}

\item{filename}{character. File path to .csv downloaded
from \url{https://www.movebank.org}.}
}
\value{
Returns a list object of length two, containing tracking data
(accessed using: \code{dataset$data}) and study site location information
(accessed using: \code{dataset$site}) .
}
\description{
\code{move2KBA} imports data from Movebank repository and re-formats them to
fit track2KBA functions.
}
\details{
This is a wrapper function for functions in \code{move} package to import and
 format tracking data from Movebank. It also attains study site location data
  (lat/lons).
}
\examples{
\dontrun{

dataset <- move2KBA(movebankID=xxx, user="myusername", password="mypassword")

tracks <- dataset$data  ## access tracking data
site   <- dataset$site    ## access study site coordinates
}

}
\seealso{
\code{\link[move]{getMovebankData}} for data download,
\code{\link[move]{getMovebank}} for study metadata,
\code{\link[move]{getMovebankID}} for getting study ID number
}
