% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_smoother.R, R/zzz_aliases.R
\name{smoother_control.trackeRdata}
\alias{smoother_control.trackeRdata}
\alias{smootherControl.trackeRdata}
\title{Auxiliary function for \code{\link{smoother.trackeRdata}}. Typically used to construct
a control argument for \code{\link{smoother.trackeRdata}}.}
\usage{
smoother_control.trackeRdata(fun = "mean", width = 10, parallel = FALSE,
  what = c("speed", "heart_rate"), nsessions = NA, ...)

smootherControl.trackeRdata(fun = "mean", width = 10, parallel = FALSE,
  what = c("speed", "heart_rate"), nsessions = NA, ...)
}
\arguments{
\item{fun}{The name of the function to be matched and used to
aggregate/smooth the data.}

\item{width}{The width of the window in which the raw observations
get aggregated via function \code{fun}.}

\item{parallel}{Logical. Should computation be carried out in
parallel? If \code{TRUE} computation is performed in parallel
using the backend provided to \code{\link{foreach}}. Default is
\code{FALSE}.}

\item{what}{Vector of the names of the variables which should be
smoothed.}

\item{nsessions}{Vector containing the number of session. Default
corresponds to all sessions belonging to the same group. Used
only internally.}

\item{...}{Currently not used.}
}
\description{
Auxiliary function for \code{\link{smoother.trackeRdata}}. Typically used to construct
a control argument for \code{\link{smoother.trackeRdata}}.
}
\seealso{
\code{\link{smoother.trackeRdata}}
}
