% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholds.R, R/trackeR.R
\name{threshold.trackeRdata}
\alias{threshold.trackeRdata}
\alias{threshold}
\title{Thresholding for variables in \code{trackeRdata} objects}
\usage{
\method{threshold}{trackeRdata}(object, variable, lower, upper, sport,
  trace = FALSE, ...)

threshold(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{variable}{A vector containing the names of the variables to
which thresholding is applied. See Details.}

\item{lower}{A vector containing the corresponding lower
thresholds. See Details.}

\item{upper}{A vector containing the corresponding upper
thresholds. See Details.}

\item{sport}{A vector of sports (amongst \code{'cycling'},
\code{'running'}, \code{'swimming'}) with each element
corresponding to \code{variable}, \code{lower} and \code{upper}}

\item{trace}{Should a progress report be printed? Default is \code{FALSE}}

\item{...}{Currently not used.}
}
\description{
Thresholding for variables in \code{trackeRdata} objects
}
\details{
\code{lower} and \code{upper} are always understood as referring to
the units of the \code{object}.

If the arguments \code{variable}, \code{lower}, and \code{upper}
are all unspecified, the following default thresholds are employed
\itemize{
\item latitude [-90, 90] degrees
\item longitude [-180, 180] degrees
\item altitude [-500, 9000] m
\item distance [0, Inf] meters
\item cadence_running [0, Inf] steps per min
\item cadence_cycling [0, Inf] revolutions per min
\item speed [0, Inf] meters
\item heart rate [0, 250] bpm
\item power [0, Inf] W
\item pace [0, Inf] min per km
\item duration [0, Inf] seconds
\item temperature [-20, 60] C
}
after they have been tranformed to the units of the \code{object}

The thresholds for speed differ across sports: for running they are
[0, 12.5] meters per second, for cycling [0, 100] meters per second
and for swimming [0, 5] meters per second.
}
\examples{
\dontrun{
data('runs', package = 'trackeR')
plot(runs, session = 4, what = 'speed', threshold = FALSE)
runsT <- threshold(runs, variable = 'speed', lower = 0, upper = 12.5, sport = "running")
plot(runsT, session = 4, what = 'speed', threshold = FALSE)
}
}
