% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_bearing.R
\name{track_bearing}
\alias{track_bearing}
\title{Track bearing}
\usage{
track_bearing(x, y)
}
\arguments{
\item{x}{longitude}

\item{y}{latitude}
}
\value{
a numeric vector of absolute bearing in degrees, see Details
}
\description{
Calculate sequential bearing on longitude, latitude input vectors. The unit of bearing is degrees.
}
\details{
By convention the last value is set to \code{NA} missing value, because the bearing
applies to the segment extending from the current location.

To use this on multiple track ids, use a grouped data frame with tidyverse code like
\code{data \%>\% group_by(id) \%>\% mutate(turn = track_bearing(lon, lat))}.

Absolute bearing is relative to North (0), and proceeds clockwise positive and anti-clockwise
negative \verb{N = 0, E = 90, S = +/-180, W = -90}.

The last value will be \code{NA} as the bearing is relative to the first point of each segment.
}
\examples{
track_bearing(trips0$x, trips0$y)[1:10]
}
