% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1measures.R
\name{step1measures}
\alias{step1measures}
\title{Compute 24 Measures Describing the Features of the Trajectories}
\usage{
step1measures(Data, ID = FALSE, verbose = TRUE)
}
\arguments{
\item{Data}{A \emph{n} by \emph{m} matrix or data frame containing the values of each individual trajectory. Each row corresponds to one of the \emph{n} trajectories, while the \emph{m} columns correspond to the ordered values of a given trajectory. See details.}

\item{ID}{Logical. Set to \code{TRUE} if the first column of \code{Data} corresponds to an \code{ID} variable. Defaults to \code{FALSE}.}

\item{verbose}{Logical. Set to \code{TRUE} to print information on screen. Defaults to \code{TRUE}.}
}
\value{
trajMeasures, object containing the data used for the calculations and the 24 measures.
}
\description{
Compute 24 measures for each of the Trajectories. See details for the list of measures.
}
\details{
There must be a minimum of 4 observations for each trajectory or the trajectory will be omitted from the analysis. The
trajectories do not need to have the same number of observations, nor the same values of \code{Time}.

When \code{ID} is set to \code{FALSE}, a generic \code{ID} variable is created and appended as the first
colunm of both the \code{Data} and \code{Time} data.frames.
The 24 measures are:
\enumerate{
\item Range\cr
\item Mean-over-time*\cr
\item Standard deviation (SD)\cr
\item Coefficient of variation (CV)\cr
\item Change\cr
\item Mean change per unit time\cr
\item Change relative to the first score\cr
\item Change relative to the mean over time\cr
\item Slope of the linear model*\cr
\item R^2: Proportion of variance explained by the linear model\cr
\item Maximum of the first differences\cr
\item SD of the first differences\cr
\item SD of the first differences per time unit\cr
\item Mean of the absolute first differences*\cr
\item Maximum of the absolute first differences\cr
\item Ratio of the maximum absolute difference to the mean-over-time\cr
\item Ratio of the maximum absolute first difference to the slope\cr
\item Ratio of the SD of the first differences to the slope\cr
\item Mean of the second differences\cr
\item Mean of the absolute second differences\cr
\item Maximum of the absolute second differences\cr
\item Ration of the maximum absolute second difference to the mean-over-time\cr
\item Ratio of the maximum absolute second difference to mean absolute first difference\cr
\item Ratio of the mean absolute second difference to the mean absolute first difference\cr
}
\itemize{
\item If a measure is equal to zero, it will be set to the smallest, non-zero value of the same measure across the sample during further calculations.
If Y_1, the first observation of the trajectory of an individual, is equal to zero, it will aslo be replaced.
}

For the exact equations of the measures, please go to "User guides, package vignettes and other documentation"
section of the "traj" package.
}
\examples{
\dontrun{
# Setup data
data = example.data$data

# Run step1measures
s1 = step1measures(data, ID=TRUE)

# Display measures
head(s1$measurments)

# Plot mean trajectory of all individuals
plot(s1$measurments$ID, s1$measurments$m5)

# The next step would be to run "step2factors"
}

}
\author{
Marie-Pierre Sylvestre, Dan Vatnik

marie-pierre.sylvestre@umontreal.ca
}
